/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.secureftp.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.filesystem.ftp.Policy;
import com.aptana.filesystem.secureftp.SFTPConnectionPoint;
import com.aptana.filesystem.secureftp.SecureUtils;
import com.aptana.ide.core.io.ConnectionPointType;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IBaseRemoteConnectionPoint;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ui.ftp.internal.FTPAdvancedOptionsComposite;
import com.aptana.ui.ftp.internal.FTPConnectionPropertyComposite;
import com.aptana.ui.ftp.internal.IOptionsComposite;
import com.aptana.ui.secureftp.SecureFTPUIPlugin;
import com.aptana.ui.secureftp.dialogs.Messages;
import com.aptana.ui.secureftp.internal.FTPSAdvancedOptionsComposite;
import com.aptana.ui.secureftp.internal.SFTPAdvancedOptionsComposite;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CommonFTPConnectionPropertyComposite
extends FTPConnectionPropertyComposite {
    private static final ConnectionPointType[] PROTOCOL_TYPES = new ConnectionPointType[]{CoreIOPlugin.getConnectionPointManager().getType("ftp"), CoreIOPlugin.getConnectionPointManager().getType("ftps"), CoreIOPlugin.getConnectionPointManager().getType("sftp")};
    private Combo protocolButton;
    private Composite keyAuthComposite;
    private Button keyAuthButton;
    private Label keyPathLabel;
    private Composite[] advancedOptionsComposites;
    private ConnectionPointType connectionType;
    private FTPConnectionPropertyComposite.IListener listener;

    public CommonFTPConnectionPropertyComposite(Composite parent, int style, IBaseRemoteConnectionPoint connectionPoint, FTPConnectionPropertyComposite.IListener listener) {
        super(parent, style, connectionPoint, listener);
        this.listener = listener;
    }

    public ConnectionPointType getConnectionPointType() {
        if (this.connectionType != null) {
            return this.connectionType;
        }
        return super.getConnectionPointType();
    }

    public void setConnectionPointType(ConnectionPointType type) {
        this.changeProtocolType(type);
    }

    public void setConnectionPoint(IBaseRemoteConnectionPoint connectionPoint) {
        super.setConnectionPoint(connectionPoint);
        if (this.ftpConnectionPoint != null) {
            this.setConnectionPointType(CoreIOPlugin.getConnectionPointManager().getType((IConnectionPoint)this.ftpConnectionPoint));
        }
    }

    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        String message = null;
        if (this.keyAuthButton.getSelection()) {
            IPath keyFilePath = Path.fromPortableString((String)this.keyPathLabel.getText());
            try {
                boolean passphraseProtected = SecureUtils.isKeyPassphraseProtected((File)keyFilePath.toFile());
                char[] password = this.passwordText.getText().toCharArray();
                if (passphraseProtected && password.length > 0 && !SecureUtils.isPassphraseValid((File)keyFilePath.toFile(), (char[])password)) {
                    message = Messages.CommonFTPConnectionPointPropertyDialog_IncorrectPassphrase;
                }
            }
            catch (CoreException e) {
                message = e.getLocalizedMessage();
            }
        }
        this.listener.error(message);
        return message == null;
    }

    protected void createSiteSection(Composite parent) {
        super.createSiteSection(parent);
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtil.makeFormLabel((String)Messages.CommonFTPConnectionPointPropertyDialog_Protocol));
        this.protocolButton = new Combo(parent, 12);
        String[] items = new String[PROTOCOL_TYPES.length];
        int i = 0;
        while (i < items.length) {
            items[i] = PROTOCOL_TYPES[i].getName();
            ++i;
        }
        this.protocolButton.setItems(items);
        this.updateProtocolButton();
        this.protocolButton.setLayoutData((Object)GridDataFactory.swtDefaults().hint(Math.max(new PixelConverter((Control)this.protocolButton).convertHorizontalDLUsToPixels(61), this.protocolButton.computeSize((int)-1, (int)-1, (boolean)true).x), -1).create());
        this.protocolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonFTPConnectionPropertyComposite.this.changeProtocolType(PROTOCOL_TYPES[CommonFTPConnectionPropertyComposite.this.protocolButton.getSelectionIndex()]);
            }
        });
    }

    protected void createPasswordSection(Composite parent) {
        this.keyAuthComposite = new Composite(parent, 0);
        this.keyAuthComposite.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).grab(true, false).create());
        CommonFTPConnectionPropertyComposite.makeVisible((Control)this.keyAuthComposite, false);
        this.keyAuthComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(LayoutConstants.getSpacing().x, 0).numColumns(2).create());
        Label label = new Label(this.keyAuthComposite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(55), -1).create());
        this.keyAuthButton = new Button(this.keyAuthComposite, 32);
        this.keyAuthButton.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.keyAuthButton.setText(Messages.CommonFTPConnectionPointPropertyDialog_UsePublicKeyAuthentication);
        label = new Label(this.keyAuthComposite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(55), -1).create());
        this.keyPathLabel = new Label(this.keyAuthComposite, 0);
        this.keyPathLabel.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.keyPathLabel.setFont(this.smallFont);
        this.keyPathLabel.setText(Messages.CommonFTPConnectionPointPropertyDialog_NoPrivateKeySelected);
        super.createPasswordSection(parent);
        this.updateKeyAuth();
        this.keyAuthButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonFTPConnectionPropertyComposite.this.changeKeyAuthentication();
                CommonFTPConnectionPropertyComposite.this.validate();
            }
        });
    }

    protected void createAdvancedOptions(Composite parent) {
        Composite[] compositeArray = this.advancedOptionsComposites = new Composite[]{new FTPAdvancedOptionsComposite(parent, 0, (IOptionsComposite.IListener)this), new FTPSAdvancedOptionsComposite(parent, 0, (IOptionsComposite.IListener)this), new SFTPAdvancedOptionsComposite(parent, 0, (IOptionsComposite.IListener)this)};
        int n = this.advancedOptionsComposites.length;
        int n2 = 0;
        while (n2 < n) {
            Composite composite = compositeArray[n2];
            composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
            CommonFTPConnectionPropertyComposite.makeVisible((Control)composite, false);
            ++n2;
        }
        this.updateAdvancedOptions();
    }

    protected String getAuthId(IBaseRemoteConnectionPoint connectionPoint) {
        if ("sftp".equals(this.getConnectionPointType().getType()) && this.keyAuthButton.getSelection()) {
            return Policy.generateAuthId((String)(String.valueOf(this.getConnectionPointType().getType().toUpperCase()) + "/PUBLICKEY"), (IBaseRemoteConnectionPoint)connectionPoint);
        }
        return super.getAuthId(connectionPoint);
    }

    protected void loadPropertiesFrom(IBaseRemoteConnectionPoint connectionPoint) {
        if (connectionPoint instanceof SFTPConnectionPoint) {
            SFTPConnectionPoint sftpConnectionPoint = (SFTPConnectionPoint)connectionPoint;
            IPath keyFilePath = sftpConnectionPoint.getKeyFilePath();
            CommonFTPConnectionPropertyComposite.makeVisible((Control)this.passwordLabel, true);
            CommonFTPConnectionPropertyComposite.makeVisible((Control)this.passwordText, true);
            CommonFTPConnectionPropertyComposite.makeVisible((Control)this.savePasswordButton, true);
            if (keyFilePath != null && !keyFilePath.isEmpty()) {
                this.keyAuthButton.setSelection(true);
                this.keyPathLabel.setText(keyFilePath.toOSString());
                this.passwordLabel.setText(StringUtil.makeFormLabel((String)Messages.CommonFTPConnectionPointPropertyDialog_Passphrase));
                try {
                    boolean passphraseProtected = SecureUtils.isKeyPassphraseProtected((File)keyFilePath.toFile());
                    CommonFTPConnectionPropertyComposite.makeVisible((Control)this.passwordLabel, passphraseProtected);
                    CommonFTPConnectionPropertyComposite.makeVisible((Control)this.passwordText, passphraseProtected);
                    CommonFTPConnectionPropertyComposite.makeVisible((Control)this.savePasswordButton, passphraseProtected);
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)SecureFTPUIPlugin.getDefault(), (Throwable)e);
                }
            }
            this.updateLayout();
        }
        super.loadPropertiesFrom(connectionPoint);
    }

    protected boolean savePropertiesTo(IBaseRemoteConnectionPoint connectionPoint) {
        boolean updated = false;
        if (connectionPoint instanceof SFTPConnectionPoint) {
            SFTPConnectionPoint sftpConnectionPoint = (SFTPConnectionPoint)connectionPoint;
            if (this.keyAuthButton.getSelection()) {
                IPath keyFilePath = Path.fromPortableString((String)this.keyPathLabel.getText());
                if (!connectionPoint.getPath().equals((Object)keyFilePath)) {
                    sftpConnectionPoint.setKeyFilePath(keyFilePath);
                    updated = true;
                }
            }
        }
        return super.savePropertiesTo(connectionPoint) || updated;
    }

    private void updateProtocolButton() {
        int currentIndex = Arrays.asList(PROTOCOL_TYPES).indexOf(this.getConnectionPointType());
        if (currentIndex == -1) {
            currentIndex = 0;
        }
        this.protocolButton.setText(PROTOCOL_TYPES[currentIndex].getName());
    }

    private void updateKeyAuth() {
        boolean keyAuthEnabled = "sftp".equals(this.getConnectionPointType().getType());
        CommonFTPConnectionPropertyComposite.makeVisible((Control)this.keyAuthComposite, keyAuthEnabled);
        this.keyAuthButton.setSelection(false);
        this.changeKeyAuthentication();
    }

    private void updateAdvancedOptions() {
        int currentIndex = Arrays.asList(PROTOCOL_TYPES).indexOf(this.getConnectionPointType());
        if (currentIndex == -1) {
            currentIndex = 0;
        }
        Composite[] compositeArray = this.advancedOptionsComposites;
        int n = this.advancedOptionsComposites.length;
        int n2 = 0;
        while (n2 < n) {
            Composite composite = compositeArray[n2];
            CommonFTPConnectionPropertyComposite.makeVisible((Control)composite, false);
            ++n2;
        }
        Composite advancedOptionComposite = this.advancedOptionsComposites[currentIndex];
        CommonFTPConnectionPropertyComposite.makeVisible((Control)advancedOptionComposite, true);
        this.advancedOptions = (IOptionsComposite)advancedOptionComposite;
    }

    private void changeProtocolType(ConnectionPointType newType) {
        if (newType == null || newType.equals(this.getConnectionPointType())) {
            return;
        }
        this.connectionType = newType;
        this.updateProtocolButton();
        this.updateKeyAuth();
        this.updateAdvancedOptions();
        this.updateLayout();
        this.ftpConnectionPoint = this.getOrCreateConnectionPoint(this.connectionType);
        this.advancedOptions.loadPropertiesFrom((Object)this.ftpConnectionPoint);
    }

    private void changeKeyAuthentication() {
        boolean enabled = this.keyAuthButton.getSelection();
        if (enabled) {
            String keyFilePath;
            String ssh_home = SecureUtils.getSSH_HOME();
            while (true) {
                File dir;
                FileDialog dlg = new FileDialog(this.getShell(), 4096);
                dlg.setText(Messages.CommonFTPConnectionPointPropertyDialog_SpecifyPrivateKey);
                if (ssh_home != null && ssh_home.length() != 0 && (dir = new File(ssh_home)).exists() && dir.isDirectory()) {
                    dlg.setFilterPath(ssh_home);
                    String[] stringArray = SecureUtils.getPrivateKeys();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray[n2];
                        if (new File(dir, key).exists()) {
                            dlg.setFileName(key);
                            break;
                        }
                        ++n2;
                    }
                }
                if ((keyFilePath = dlg.open()) == null) {
                    this.keyAuthButton.setSelection(false);
                    return;
                }
                try {
                    boolean passphraseProtected = SecureUtils.isKeyPassphraseProtected((File)new File(keyFilePath));
                    CommonFTPConnectionPropertyComposite.makeVisible((Control)this.passwordLabel, passphraseProtected);
                    CommonFTPConnectionPropertyComposite.makeVisible((Control)this.passwordText, passphraseProtected);
                    CommonFTPConnectionPropertyComposite.makeVisible((Control)this.savePasswordButton, passphraseProtected);
                }
                catch (CoreException e) {
                    UIUtils.showErrorMessage((String)Messages.CommonFTPConnectionPointPropertyDialog_ERR_PrivateKey, (String)e.getLocalizedMessage());
                    continue;
                }
                break;
            }
            this.keyPathLabel.setText(keyFilePath);
            this.passwordText.setText("");
        } else {
            this.keyPathLabel.setText(Messages.CommonFTPConnectionPointPropertyDialog_NoPrivateKeySelected);
            CommonFTPConnectionPropertyComposite.makeVisible((Control)this.passwordLabel, true);
            CommonFTPConnectionPropertyComposite.makeVisible((Control)this.passwordText, true);
            CommonFTPConnectionPropertyComposite.makeVisible((Control)this.savePasswordButton, true);
        }
        this.updateLayout();
        this.passwordLabel.setText(StringUtil.makeFormLabel((String)(enabled ? Messages.CommonFTPConnectionPointPropertyDialog_Passphrase : Messages.CommonFTPConnectionPointPropertyDialog_Password)));
        this.savePasswordButton.setSelection(false);
    }

    private void updateLayout() {
        Composite parent = this.getParent();
        if (parent != null) {
            parent.layout(true, true);
            if (this.listener != null) {
                this.listener.layoutShell();
            }
        }
    }

    private static void makeVisible(Control control, boolean visible) {
        control.setVisible(visible);
        ((GridData)control.getLayoutData()).exclude = !visible;
    }
}

